## 15.1 知识结构
**介绍**：知识结构
+ 齐次线性方程组
	+ 有解的条件
	+ 解的性质
	+ 基础解系和解的结构
	+ 求解方法与步骤
+ 非齐次线性方程组
	+ 有解的条件
	+ 解的性质
	+ 求解方法和步骤
+ 两个方程组的公共解
+ 同解方程组 

## 15.2 线性方程组
### 15.2.1 概念引入
**概念**：方程组与向量的关系 
+ 1. 本质上，线性方程组与向量组其实是一回事，方程组问题就是向量组问题，因为方程组和向量组是同一个问题的两种表现形式，其本质一样，所以解决方法也一样；
+ 2. 而方程组的解，就是描述列向量组中各向量之间数量关系的系数；

**概念**：线性方程组
+ 举例： 
+ $\begin{gathered}2 x+5 y+3 z =-3 \\4 x+0 y+8 z =0 \\1 x+3 y+0 z =2 \end{gathered}$

**概念**：从线性方程组到矩阵
+ 矩阵方程： 
	+ `Ax=v`
+ 意义： 
	+ 当前我们存在一个向量 `x`，我们可以通过 `A` 这个矩阵，在对 x 进行线性变换后、使得 x 和向量 `v` 重合；
+ 图示： 
	+ ![[Pasted image 20240627210554.png]]

**分析**：假设当前是二维矩阵 `A` 
+ 情况一：矩阵 A 的行列式不为 `0` 时
	+ 意义： 
		+ 此时空间并未被挤压为 `0` 面积的区域；
		+ 在这种情况下，有且仅有一个向量 (在变换后)与 v 重合；
		+ 这也就意味着：对于一个行列式不为 0 的方程组，几乎可以确定其存在的唯一解；
	+ 总结： 
		+ 只要变换后不将解空间压缩到一个更低的维度上（即 A 的行列式不为 0），则 A 存在的逆变换，使得应用 `A` 变换再应用 `A` 逆变换之后，结果与恒等变换无异；
		+ 此时求解方程：$$Ax=v\rightarrow A^{-1}A\vec{\mathbf{x}}=A^{-1}\vec{\mathbf{v}}\rightarrow x=A^{-1}v$$
+ 情况二：矩阵 A 的行列式为 `0` 时
	+ 意义： 
		+ 此时不是矩阵没有逆变换，与这个方程组相关的变换将空间压缩到更低的维度上；
		+ 当 $A\vec{\mathbf{x}}=\left[\begin{array}{cc}0\\0\end{array}\right]$ 时，零空间给出的就是这个向量方程所有可能的解；
+ 补充：关于逆矩阵
	+ $$\begin{array}{|c|c|c|}\hline A^{-1}A=&\begin{bmatrix}1&0\\0&1\end{bmatrix}\\\hline\text{The transformation}\\\hline\text{that does nothing}\\\hline\text{“什么都不做”的变换}\\\hline\end{array}$$
+ 

### 15.2.2 定义
##### **定义**： #齐次方程 
> <font color="#ccc1d9">描述：</font>如果将函数的所有自变量乘以一个非零因子，此时因变量相当于原函数乘以这个非零因子的幂，则称此函数为齐次函数。即需满足关系: $$f\left(tx_{1},tx_{2},tx_{3},\cdots,tx_{n}\right)=t^{k}f\left(x_{1},x_{2},x_{3},\cdots,x_{n}\right),t\neq0$$

**解释**
+ 举例：$$f(x,y)=\frac{x^{2}-2xy}{xy+3y^{2}}$$
	+ 其是一个零次齐次方程； 

##### **定义**： #非齐次线性方程组 
> <font color="#ccc1d9">描述：</font> 
> 非齐次线性方程组： $$\begin{cases}a_{11}x_{1}+a_{12}x_{2}+\cdots+a_{1n}x_{n}=b_{1},\\a_{21}x_{1}+a_{22}x_{2}+\cdots+a_{2n}x_{n}=b_{2},\\\cdots\cdots\\a_{m1}x_{1}+a_{m2}x_{2}+\cdots+a_{mn}x_{n}=b_{m},\end{cases}$$
> 该方程组的**系数矩阵**就是若干个列向量拼成的：$$A=\begin{bmatrix}a_{11}&a_{12}&\cdots&a_{1n}\\a_{21}&a_{22}&\cdots&a_{2n}\\\vdots&\vdots&&\vdots\\a_{m1}&a_{m2}&\cdots&a_{mn}\end{bmatrix}$$
> 其**增广矩阵**就是系数矩阵再添加一个列向量拼成的：$$\begin{bmatrix}a_{11}&a_{12}&\cdots&a_{1n}&b_{1}\\a_{21}&a_{22}&\cdots&a_{2n}&b_{2}\\\vdots&\vdots&&\vdots&\vdots\\a_{m1}&a_{m2}&\cdots&a_{mn}&b_{m}\end{bmatrix}$$ 

**解释**
+ 概念：
	+ 该方程组的未知数就是向量组中各成员的系数；
	+ $x_{1}\alpha_{1}+x_{2}\alpha_{2}+\cdots+x_{n}\alpha_{n}=\beta$
	+ 其中：$a_{j}=\begin{bmatrix}a_{1j}\\a_{2j}\\\vdots\\a_{mj}\end{bmatrix},j=1,2,\cdots,n,\beta=\begin{bmatrix}b_{1}\\b_{2}\\\vdots\\b_{m}\end{bmatrix}$
+ 解释：
	+ 所以从本质上说，方程组问题就是向量组问题，方程组和向量组是同一个问题的两种表现形式，其本质一样，所以解决方法也一样；

## 15.3 齐次线性方程组概念
### 15.3.1 齐次线性方程组基本概念
##### **定义**： #齐次线性方程组
> <font color="#ccc1d9">描述：</font> $$\\\begin{cases}a_{11}x_{1}+a_{12}x_{2}+\cdots+a_{1n}x_{n}=0,\\a_{21}x_{1}+a_{22}x_{2}+\cdots+a_{2n}x_{n}=0,\\\cdots\cdots\\a_{m1}x_{1}+a_{m2}x_{2}+\cdots+a_{mn}x_{n}=0\end{cases}$$

**解释**
+ 向量形式： 
	+ $x_{1}a_{1}+x_{2}a_{2}+\cdots+x_{n}a_{n}=0$
	+ 即：全部都线性无关；
+ 其中： $a_{j}=\begin{bmatrix}a_{1j}\\a_{2j}\\\vdots\\a_{mj}\end{bmatrix},j=1,2,\cdots,n$
+ 其矩阵形式为：$A_{m\times n}x=0$
+ 其中： 
	+ $A_{m\times n}=\begin{bmatrix}a_{11}&a_{12}&\cdots&a_{1n}\\a_{21}&a_{22}&\cdots&a_{2n}\\\vdots&\vdots&&\vdots\\a_{m1}&a_{m2}&\cdots&a_{mn}\end{bmatrix},x=\begin{bmatrix}x_{1}\\x_{2}\\\vdots\\x_{n}\end{bmatrix}$

**概念**：线性方程的解与向量的关系
+ 方程组的解，就是描述**列向量组中各向量之间数量关系的系数**

### 15.3.2 有解的条件 
**概念**：有解的条件
+ 前提： 
	+ 对方程组：$\\\begin{cases}a_{11}x_{1}+a_{12}x_{2}+\cdots+a_{1n}x_{n}=0,\\a_{21}x_{1}+a_{22}x_{2}+\cdots+a_{2n}x_{n}=0,\\\cdots\cdots\\a_{m1}x_{1}+a_{m2}x_{2}+\cdots+a_{mn}x_{n}=0\end{cases}$
+ 条件： 
	+ 情况 1
		+ 描述： 
			+ $$当r\left(A\right)=n\left(\alpha_{1},\alpha_{2},\cdots,\alpha_{n}\text{线性无关}\right)\text{时,方程组}\left(I\right)\text{有唯一零解}$$
		+ 概念：
			+ 当 $A$ 是 $A_{m*n}$ 时，其中的 $m$ 代表行数，可以小于 $m$；但 $n$ 代表列数，即 $n$ 个未知数就是 $n$ 个；
		+ 解释：
			+ 如果系数方程的列满秩，则系数方程只有唯一零解（唯一解）；
			+ 即：当前方程组的 `S=n-r(A)=0`，`n` 代表列数，即多少个向量，而 `r(A)` 代表秩，`S` 代表加上**秩代表的限制之后的自由度**，当 `S=0` 时，满秩，因此唯一零解；
	+ 情况 2 
		+ 描述： 
			+ $$\text{当}r(A)=r<n\left(a_1,a_2,\cdots,a_n\text{线性相关}\right)\text{时,方程组}\left(I\right)\text{有非零解}\left(\text{无穷多解}\right),\text{且有}n-r\text{个线性无关解}$$ 
		+ 解释： 
			+ 可以用 `S=n-r(A)` 来计算受约束后的自由度；
			+ `n` 表示自由度；
			+ `r(A)` 表示真实的约束个数；
			+ `S` 代表受约束的自由度，即当前方程组的解空间；
		+ 举例：比如假设 `n=5, r=3` ，当 `n-r=2` 时； 
			+ 表示：在一个五维的空间当中，有三个自变量的约束，因此只有两个自由的变量；
			+ 这两个自由的维度构成了一个平面，这个平面就是其解空间；
+ 分析： 
	+ 考题主要靠第二种；
	+ 即方程组一般是“胖胖呼呼方程组” `<-` `m<n`

### 15.3.3 基础解系和解的结构 
##### **定义**： #基础解系 
> <font color="#ccc1d9">描述：</font>基础解系：$\xi_{1},\xi_{2},\cdots,\xi_{n-r}$ 满足以下三个条件 `<-` 对于 `r(A)<n` 的情况：
> 1. 是方程组 `AX=0` 的解；
> 2. 线性无关；
> 3. 方程组 `AX=0` 的任一解均可由 $\xi_{1},\xi_{2},\cdots,\xi_{n-r}$ 线性表示
> 则称 $\xi_{1},\xi_{2},\cdots,\xi_{n-r}$ 位 `AX=0` 的基础解系；

**解释**
+ 作用：基础解系代表受到真实约束后的解的空间（`S=n-r(A)`）；

##### **定义**： #通解 
> <font color="#ccc1d9">描述：</font> $$\text{设}\quad\xi_1,\xi_2,\cdots,\xi_{n-r}\quad\text{是}Ax=0\text{ 的基础解系,则}\quad{k_1\xi_1+k_2\xi_2+\cdots+k_{n-r}\xi_{n-r}\quad\text{是方程组}Ax=0\text{ 的通解,}}其中k为任意常数.$$

**解释**
+ 基础解系的线性组合可以表达解空间中的所有向量，因此可以用 $k_1\xi_1+k_2\xi_2+\cdots+k_{n-r}\xi_{n-r}$ 表示； 
+ 其中的系数就是其在坐标系中的坐标； 

## 15.4 求解方法与步骤 
**步骤**：齐次线性方程求解
+ 第一步：
	+ 1.1 将系数矩阵 `A` 作初等行变换，化成行阶梯形矩阵 `B` 
		+ 补充：
			+ 一定是初等行变换；
			+ 或行最简阶梯形矩阵 `B`；
		+ 概念： 
			+ 初等行变换将方程组化为同解方程组，故 `Ax=0` 和 `Bx=0` 同解，只需解 `Bx=0` 即可；
		+ 名词： 
			+ **基础解系 = 线性无关解 = `S=n-r()`**
	+ 1.2 台阶数为 r，并记 `r(A)=r`；
		+ 阶梯矩阵的台阶数就是约束的个数，即秩的大小；
		+ 补充：阶梯型矩阵的 `行秩=列秩=秩`，但一般就直接按照列秩：数台阶数就可以求得；
	+ 1.3 公式： 
		+ $$A\xrightarrow{\text{初等行变换}}B=\begin{bmatrix}c_{11}&c_{12}&\cdots&c_{1r}&\cdots&c_{1n}\\0&c_{22}&\cdots&c_{2r}&\cdots&c_{2n}\\\vdots&\vdots&&\vdots&&\vdots\\0&0&\cdots&c_{rr}&\cdots&c_{m}\\0&0&\cdots&0&\cdots&0\\\vdots&\vdots&&\vdots&&\vdots\\0&0&\cdots&0&\cdots&0\end{bmatrix}_{m\times n},$$
		+ 其中 `m` 是原方程组中方程个数，`n` 是未知量个数；
+ 第二步： 
	+ 按列找出秩为 `r` 的子矩阵，剩余列位置的未知数设为自由变量；
	+ 注意：按列找是 `r` 个，按行找肯定也是 `r` 个，但按列找更方便；
+ 第三步： 
	+ 按基础解系定义，求出 $\xi_{1},\xi_{2},\cdots,\xi_{n-r}$ ，并写出通解；
	+ 补充： 
		+ `S=2`，即两个向量时：可以定义一个 `(1,0)` 和一个 `(0,1)`
		+ `S=1`，即一个向量时：只要不是零向量即可，可以选一个 `(1)`

